/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import catserver.server.AsyncCatcher;
import catserver.server.BukkitWorldDimensionManager;
import catserver.server.CatServerConfig;
import catserver.server.threads.AsyncChatThread;
import catserver.server.threads.AsyncTaskThread;
import catserver.server.threads.RealtimeThread;
import catserver.server.utils.VersionCheck;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CatServer {
    public static final Logger log = LogManager.getLogger((String)"CatServer");
    private static final String version = "2.1.0";
    private static final String native_version = "v1_12_R1";
    private static final CatServerConfig config = new CatServerConfig("catserver.yml");

    public static String getVersion() {
        return version;
    }

    public static String getNativeVersion() {
        return native_version;
    }

    public static void onServerStart() {
        RealtimeThread.INSTANCE.start();
        new VersionCheck();
    }

    public static void onServerStop() {
        AsyncTaskThread.shutdown();
        AsyncChatThread.shutdown();
    }

    public static void onWorldDataLave(bfb handler, bfd worldInfo, fy tagCompound) {
        fy catserverData = tagCompound.p("catserver");
        BukkitWorldDimensionManager.load(catserverData);
    }

    public static void onWorldDataSave(bfb handler, bfd worldInfo, fy tagCompound) {
        fy catserverData = new fy();
        BukkitWorldDimensionManager.save(catserverData);
        tagCompound.a("catserver", (gn)catserverData);
    }

    public static CatServerConfig getConfig() {
        return config;
    }

    public static boolean asyncCatch(String reason) {
        return AsyncCatcher.checkAsync(reason);
    }

    public static void postPrimaryThread(Runnable runnable) {
        MinecraftServer.getServerInst().processQueue.add(runnable);
    }

    public static void scheduleAsyncTask(Runnable runnable) {
        AsyncTaskThread.schedule(runnable);
    }

    public static int getCurrentTick() {
        return CatServer.getConfig().enableRealtime ? RealtimeThread.currentTick : MinecraftServer.currentTick;
    }
}

